# brltty.spec.  Generated from brltty.spec.in by configure.
###############################################################################
# BRLTTY - A background process providing access to the console screen (when in
#          text mode) for a blind person using a refreshable braille display.
#
# Copyright (C) 1995-2025 by The BRLTTY Developers.
#
# BRLTTY comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU Lesser General Public License, as published by the Free Software
# Foundation; either version 2.1 of the License, or (at your option) any
# later version. Please see the file LICENSE-LGPL for details.
#
# Web Page: http://brltty.app/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.
###############################################################################

Name: brltty
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Vendor: The BRLTTY Developers
Packager: Dave Mielke <dave@mielke.cc>
URL: https://brltty.app/
Source: https://brltty.app//archive/%{name}-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _pkglibdir %{_libdir}/%{name}
%define _pkglibexecdir %{_libexecdir}/%{name}

Requires: cldr-emoji-annotation
Requires: dbus-libs
Requires: expat
Requires: libcap
Requires: libicu
Requires: liblouis
Requires: pcre2-utf32
Requires: polkit-libs

BuildRequires: systemd-rpm-macros

BuildRequires: /bin/sh
BuildRequires: /usr/bin/env

BuildRequires: bash
BuildRequires: gawk
BuildRequires: coreutils
BuildRequires: binutils
BuildRequires: tcl

BuildRequires: autoconf >= 2.53
BuildRequires: automake
BuildRequires: make
BuildRequires: pkgconf-pkg-config
BuildRequires: gcc

BuildRequires: alsa-lib-devel
BuildRequires: bluez-libs-devel
BuildRequires: dbus-devel
BuildRequires: expat-devel
BuildRequires: glibc-devel
BuildRequires: glib2-devel
BuildRequires: gpm-devel
BuildRequires: libcap-devel
BuildRequires: libicu-devel
BuildRequires: liblouis-devel
BuildRequires: ncurses-devel
BuildRequires: pcre2-devel
BuildRequires: polkit-devel
BuildRequires: systemd-devel

BuildRequires: gettext
BuildRequires: groff
BuildRequires: doxygen
BuildRequires: linuxdoc-tools
BuildRequires: python3-docutils
BuildRequires: rst2txt

AutoProv: no
AutoReq: yes

Provides: brlapi-server
Provides: config(%{name}) = %{version}

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.


%package utils
Version: 6.9
Release: 1
Group: Development/Tools
License: LGPL

Requires: libicu
Requires: expat
Requires: cldr-emoji-annotation

BuildRequires: libicu-devel
BuildRequires: expat-devel
BuildRequires: ncurses-devel

AutoProv: no
AutoReq: yes

Summary: Commands for maintaining BRLTTY data files.
%description utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%package devel
Version: 6.9
Release: 1
Group: Development/Tools
License: LGPL

AutoProv: no
AutoReq: yes

Summary: Headers for BRLTTY.
%description devel
This package provides many of the header files for BRLTTY's core, as well as
header files which define the packets and keys for several braille devices.

Install this package if you're developing or maintaining an application which
needs to (or wishes to) use functionality provided by BRLTTY's core, which
needs to interpret and/or create raw braille device packets, or which needs to
interpret key codes as delivered by BrlAPI's raw mode.


%package braille-brlapi
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

AutoProv: no
AutoReq: yes

Summary: BrlAPI braille driver for BRLTTY.
%description braille-brlapi
This package provides the BrlAPI braille driver for BRLTTY.

Install this package if you need to communicate with
another instance of BRLTTY which is actually in control
of the braille device.


%package braille-xwindow
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: libX11

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: Xaw3d-devel

AutoProv: no
AutoReq: yes

Summary: XWindow braille driver for BRLTTY.
%description braille-xwindow
This package provides the XWindow braille driver for BRLTTY.
This driver presents a virtual braille device within a graphical
user interface. It is primarily intended for sighted developers
who don't have access to a real braille device but still wish to
assess the accessibility of their applications.

Install this package if you would like to see how usable an
application would be by a blind person using a braille device.


%package speech-espeak
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: espeak

BuildRequires: espeak-devel

AutoProv: no
AutoReq: yes

Summary: eSpeak speech driver for BRLTTY.
%description speech-espeak
This package provides the eSpeak speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak text-to-speech engine.


%package speech-espeak-ng
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: espeak-ng

BuildRequires: espeak-ng-devel

AutoProv: no
AutoReq: yes

Summary: eSpeak-NG speech driver for BRLTTY.
%description speech-espeak-ng
This package provides the eSpeak-NG speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak-NG text-to-speech engine.


%package speech-festival
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: festival

AutoProv: no
AutoReq: yes

Summary: Festival speech driver for BRLTTY.
%description speech-festival
This package provides the Festival speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival text-to-speech engine.


%package speech-flite
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: flite

BuildRequires: flite-devel

AutoProv: no
AutoReq: yes

Summary: Festival Lite speech driver for BRLTTY.
%description speech-flite
This package provides the Festival Lite speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival Lite text-to-speech engine.


%package speech-speechd
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: speech-dispatcher

BuildRequires: speech-dispatcher-devel

AutoProv: no
AutoReq: yes

Summary: Speech Dispatcher speech driver for BRLTTY.
%description speech-speechd
This package provides the Speech Dispatcher speech driver for BRLTTY.

Install this package if you would like to be able to use the
Speech Dispatcher text-to-speech server.


%package screen-atspi2
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: dbus-libs

BuildRequires: at-spi2-core-devel
BuildRequires: xorg-x11-proto-devel
BuildRequires: dbus-devel

AutoProv: no
AutoReq: yes

Summary: AT-SPI2 screen driver for BRLTTY.
%description screen-atspi2
This package provides the AT-SPI2 screen driver for BRLTTY.

Install this package if you would like to be able to
access graphical applications via the D-Bus port of
the Assistive Technology Service Provider Interface.


%package screen-screen
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL

AutoProv: no
AutoReq: yes
Requires: screen

Summary: Screen screen driver for BRLTTY.
%description screen-screen
This package provides the Screen screen driver for BRLTTY.

Install this package if you would like to be able to
directly access session windows maintained by the
screen program.


%package -n brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Application Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.


%package -n brlapi-utils
Version: 0.8.8
Release: 1
Group: Applications/System
License: LGPL

Requires: libX11

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXtst-devel

AutoProv: no
AutoReq: yes

Summary: Application Programming Interface for BRLTTY.
%description -n brlapi-utils
This package provides a set of commands that use the BrlAPI interface.


%package -n brlapi-devel
Version: 0.8.8
Release: 1
Group: Development/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.


%package -n java-brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: java
BuildRequires: java-devel

AutoProv: no
AutoReq: yes

Summary: Java bindings for BrlAPI.
%description -n java-brlapi
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.


%package -n lua-brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: lua
BuildRequires: lua-devel

AutoProv: no
AutoReq: yes

Summary: Lua bindings for BrlAPI.
%description -n lua-brlapi
This package provides the Lua bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an Lua application
which directly accesses a refreshable braille display.


%package -n ocaml-brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: ocaml
BuildRequires: ocaml-findlib

AutoProv: no
AutoReq: yes

Summary: OCaml bindings for BrlAPI.
%description -n ocaml-brlapi
This package provides the OCaml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an OCaml application
which directly accesses a refreshable braille display.


%package -n python-brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: python3
BuildRequires: python3-devel
BuildRequires: python3-Cython

AutoProv: no
AutoReq: yes

Summary: Python bindings for BrlAPI.
%description -n python-brlapi
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.


%package -n tcl-brlapi
Version: 0.8.8
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: tcl
BuildRequires: tcl-devel

AutoProv: no
AutoReq: yes

Summary: Tcl bindings for BrlAPI.
%description -n tcl-brlapi
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.


%package systemd
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd

Summary: Systemd units and wrappers for BRLTTY.
%description systemd
This package provides the units and wrapper for managing BRLTTY via Systemd.

Install this package if you'd like to manage BRLTTY processes via Systemd.


%package udev
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd-udev

Summary: BRLTTY Udev rules.
%description udev
This package provides the rules and the wrapper for managing BRLTTY via Udev.

Install this package if you'd like to manage BRLTTY processes via Udev.
It doesn't include the rules for braille devices that use generic USB to serial adapters.


%package udev-generic
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd-udev

Summary: BRLTTY Udev rules for braille devices that use a generic USB to serial adapter.
%description udev-generic
This package provides additional rules for managing BRLTTY via Udev.

Install this package in order to support braille devices that use a generic USB to serial adapter.


%package dracut
Version: 6.9
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: dracut
Requires: brltty-utils

Summary: Dracut module for BRLTTY.
%description dracut
This package provides the module for adding BRLTTY to an initial ramdisk image.

Install this package if you'd like to have braille accessibility BRLTTY processes via Udev.


%prep
# %setup -n %{name}-%{version}
%setup -n brltty-6.9

%build
export PYTHON=python3
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --with-braille-driver=-tt
make all

%install
make install
make install-messages
make install-appstream
make install-systemd
make install-udev UDEV_RULES_LOCATION=%{_udevrulesdir}
make install-polkit
make install-dracut
make install-documents
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
%find_lang %{name}

%clean
rm -fr "${RPM_BUILD_ROOT}"


%files -f %{name}.lang
%defattr(-,root,root)
%{_bindir}/brltty
%{_pkglibdir}
%{_pkglibexecdir}/brltty-pty
%exclude %{_pkglibdir}/libbrlttybba.so
%exclude %{_pkglibdir}/libbrlttybxw.so
%exclude %{_pkglibdir}/libbrlttysen.so
%exclude %{_pkglibdir}/libbrlttyses.so
%exclude %{_pkglibdir}/libbrlttysfl.so
%exclude %{_pkglibdir}/libbrlttysfv.so
%exclude %{_pkglibdir}/libbrlttyssd.so
%exclude %{_pkglibdir}/libbrlttyxa2.so
%exclude %{_pkglibdir}/libbrlttyxsc.so
%exclude %{_unitdir}
%exclude %{_udevrulesdir}
%{_sysconfdir}/brltty
%exclude %{_sysconfdir}/brltty/Initramfs/dracut.conf
%exclude %{_sysconfdir}/brltty/Initramfs/cmdline
%{_datadir}/metainfo/org.a11y.brltty.metainfo.xml
%{_libdir}/pkgconfig/brltty.*
%doc %{_mandir}/man1/brltty.1.gz
%doc %{_docdir}/*/LICENSE*
%doc %{_docdir}/*/README*
%doc %{_docdir}/*/*.html
%doc %{_docdir}/*/BUGS
%doc %{_docdir}/*/ChangeLog
%doc %{_docdir}/*/CONTRIBUTORS
%doc %{_docdir}/*/HISTORY
%doc %{_docdir}/*/TODO
%doc %{_docdir}/*/*.csv
%doc %{_docdir}/*/brltty.conf
%doc %{_docdir}/*/KeyTables
%doc %{_docdir}/*/Manual-BRLTTY
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files utils
%{_bindir}/brltty-*

%files devel
%{_includedir}/brltty

%files braille-brlapi
%{_pkglibdir}/libbrlttybba.so

%files braille-xwindow
%{_pkglibdir}/libbrlttybxw.so

%files speech-espeak
%{_pkglibdir}/libbrlttyses.so

%files speech-espeak-ng
%{_pkglibdir}/libbrlttysen.so

%files speech-festival
%{_pkglibdir}/libbrlttysfv.so

%files speech-flite
%{_pkglibdir}/libbrlttysfl.so

%files speech-speechd
%{_pkglibdir}/libbrlttyssd.so

%files screen-atspi2
%{_pkglibdir}/libbrlttyxa2.so

%files screen-screen
%{_pkglibdir}/libbrlttyxsc.so

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%{_datadir}/polkit-1/*/org.a11y.brlapi.*
%doc %{_docdir}/*/Manual-BrlAPI

%files -n brlapi-utils
%{_bindir}/xbrlapi
%doc %{_mandir}/man1/xbrlapi.1.gz
%{_datadir}/gdm/greeter/autostart/xbrlapi.desktop
%{_sysconfdir}/X11/Xsession.d/90xbrlapi
%{_bindir}/eutp
%doc %{_mandir}/man1/eutp.1.gz
%{_bindir}/vstp
%doc %{_mandir}/man1/vstp.1.gz

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%doc %{_mandir}/man3/*
%doc %{_docdir}/*/BrlAPIref

%files -n java-brlapi
/usr/share/java/*
/usr/lib/java/*

%files -n lua-brlapi
/usr/lib64/lua/5.4/

%files -n ocaml-brlapi
/usr/lib64/ocaml/brlapi

%files -n python-brlapi -f Bindings/Python/installed-files

%files -n tcl-brlapi
/usr/lib64/tcl8.6/brlapi-0.8.8/libbrlapi_tcl.so
/usr/lib64/tcl8.6/brlapi-0.8.8/pkgIndex.tcl

%files systemd
%{_unitdir}/*
%{_sysusersdir}/*
%{_tmpfilesdir}/*
%{_pkglibexecdir}/systemd-*

%files udev
%{_udevrulesdir}/*
%exclude %{_udevrulesdir}/*-generic*
%{_pkglibexecdir}/udev-*

%files udev-generic
%{_udevrulesdir}/*-generic*

%files dracut
/usr/lib/dracut/modules.d/99brltty
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty/Initramfs/dracut.conf
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty/Initramfs/cmdline


%changelog
* Tue Feb 17 2026 Dave Mielke <Dave@Mielke.cc> 6.9
General changes:
   Cursor routing no longer spawns an additional process or thread.
   Soft cursor detection (for applications that use a visual cursor) has been added
   (must be enabled within the Navigation Options submenu).
   Multi-line cursor routing has been fixed.
   A screen driver can now provide full (RGB) color for each character.
   The DESCCHAR command now shows actual color names if RGB is provided.
   Time selectors within the Preferences Menu now adjust by 0.05 (rather than 0.1) seconds.
   Timestamps within the Log Messages submenu now contain their milliseconds component.
   Command line and configuration file parsing errors are now written to the log file.
   Failure to connect to a Bluetooth device no longer spams the log.
   Failure to open a HID device no longer spams the log.
New braille navigation commands:
   COLOR: Show just the VGA or RGB color of the selected character.
   It's been bound to a long press of a routing key.
   Use this command, rather than DESCCHAR, if you just want to know the color.
New speech navigation commands:
   SPEAK_CURR_PWRD: Say the current partial word.
   SPEAK_PREV_PWRD: Move to and say the previous partial word.
   SPEAK_NEXT_PWRD: Move to and say the next partial word.
   SPELL_CURR_PWRD: Spell the current partial word.
   SPELL_CURR_LINE: Spell the current line.
   See the laptop and keypad keyboard tables for related binding changes
   (more specifically, see the kp_speak and kp_say keyboard subtables).
EuroBraille braille driver changes:
   The b.note and b.book models are now supported.
   Missing dependency rules for building the eutp command have been added.
HandyTech braille driver changes:
   The Android-specific key bindings now work.
HIMS braille driver:
   The BrailleSense 6 is now detected properly when using Bluetooth.
HumanWare braille driver changes:
   All of the models that support Bluetooth HID are now recognized by Udev.
Virtual braille driver:
   This driver has been removed.
AtSpi2 screen driver changes:
   Helpful text is now shown for widgets that don't have a text interface.
Linux screen driver changes:
   Disabling wide character padding now actually works when using a newer kernel.
Tmux screen driver:
   This is a new screen driver.
   Its two-letter code is tx.
   It supports full (RGB) color.
   The scrollback buffer, choose-tree, and display-menu features aren't supported.
   The brltty-tmux command has been added.
Speech changes:
   Navigating by partial words has been restored to the original bindings.
   Navigating by full words has been retained with different bindings.
   A command to spell the current line has been added.
   Spelling a word or line now speaks all of the punctuation symbols.
   Autorepeat for navigating by character, word, and line has bee slowed down so it can be heard.
   These selectors have been added to the Speech Options submenu:
      Character Autorepeat Interval: defaults to 0.25 seconds
      Word Autorepeat Interval:      defaults to 0.4 seconds
      Line Autorepeat Interval:      defaults to 0.6 seconds
BrlAPI changes:
   The version is now 0.8.8 (it was 0.8.7).
   Pending braille output is now flushed whenever a client leaves a tty.
   A problem when determining the tty number for a client session has been resolved.
Text table changes:
   The no-break space - U+00A0 - has been added to en-nabcc as dots 7,8.
Contraction table changes:
   de-1998 is now deprecated and has been removed.
   de-2015 is now folded into de-g2 and has been removed.
   de-g2 has been updated.
Linux changes:
   Missing special devices are now created within an isolated file system.
Windows changes:
   64-bit builds using Msys2 are now supported.
   The speech drivers for the Alva, BrailleLite, and CombiBraille are now included.
Android changes:
   The targeted API level has been increased to 36 (Android 16).
   The minimum API level has been increased to 27 (Android 8.1).
   The NDK (native development kit) now being used is r27b.
   The new 16-kilobyte page size requirement is now supported.
   The top-level build is now configured for arm 64-bit (rather than for arm 32-bit).
   The edge-to-edge screen rendering model is now supported.
   The DESCCHAR command now includes the character's name.
   The Canute braille driver is now included.
brltty-pty changes:
   The screen, screen-256color, tmux, and tmux-256color terminal types are now supported.
   The RGB escape sequence - 38;2 - is now supported.
   The bright color escape sequences - 90-97 and 100-107 - are now supported.
Build Changes:
   Scripts now use the screen's width (rather than assume 72) for help (-h) output.
   The brltty-lscmds command has been renamed to brltty-cmdref.
   brltty-ctb's --reformat-text [-r] option has been fixed and is now documented.
   The brltty-tmux command has been added.
   The cmdtest command has been added.
   The colortest command has been added.
   The all action of the msgtest command has been renamed to list.
   Cross-compiling the Java bindings is now supported.
   The Lua bindings are no longer installed in a local directory unless there's no other alternative.

